/* Copyright 2005 Code Line Communications. All rights reserved. */

var kModeText = 0;
var kModeInfo = 128;
var gMode = kModeText;
var kMinFontSize = 10;
var gMaxSize = 164;
var savedHTML;
var gCurrentFontSize;
var gCurrentFont;
var gFontFile;
var gFontContainer;

var editTop = 36;
var editHeight = 164;
var gTextHeight = 0;

var currSync = 0;

var timer = null;
var mtimer = null;
var editable = false;
var backside = false;

function getLocalizedString (key) {
	try {
		var ret = localizedStrings[key];
		if (ret == undefined)
			ret = key;
		return ret;
	} catch (ex) {}

	return key;
}

function focus() {
	if (window.widget) {
		if (TypeCastFontManager.currentSyncNum() != currSync) {
			currSync = TypeCastFontManager.currentSyncNum();
			
			var prevFont = gCurrentFont;
			var sysFont = TypeCastFontManager.getSystemFontName();
			populateFontFamilies();
			if (setFont(prevFont) || setFont(sysFont)) { }
		
		} else {
			updateLayout();
		}
	}
	if (!editable) {
		document.getElementById("edit-div").contentEditable = true;
		editable = true;
	}
}

function blur() {
	var eDiv = document.getElementById("edit-div");
	if (editable) {
		eDiv.contentEditable = false;
		editable = false;
	}
	writeWindow();
}

function onhide() {
	blur();
}

function selectall() {
	//var element = document.getElementById("front");
	var element = document.getElementById("edit-div");
	//window.getSelection().setBaseAndExtent(element.firstChild, 0, element.lastChild, element.lastChild.length);
	if (element.lastChild.lastChild) {
		window.getSelection().setBaseAndExtent(element.firstChild, 0, element.lastChild.lastChild, element.lastChild.lastChild.length);
	} else {
		window.getSelection().setBaseAndExtent(element.firstChild, 0, element.lastChild, element.lastChild.length);
	}
}

function createKey(key) {
	return widget.identifier + "-" + key;
}

function writeWindow() {
	widget.setPreferenceForKey(document.getElementById("edit-div").innerHTML, createKey("text"));
}

function onremove() {
	// remove my instance preferences when remove from dashboard
	widget.setPreferenceForKey(null, createKey("text"));
	widget.setPreferenceForKey(null, createKey("font"));
	widget.setPreferenceForKey(null, createKey("size"));
}

window.onfocus = focus;
window.onblur = blur;

if (window.widget) {
	widget.onhide = onhide;
	widget.onremove = onremove;
}

function showbackside(event) {
	var front = document.getElementById("front");
	var back = document.getElementById("behind");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");
	
	front.style.display="none";
	back.style.display="block";
	
	if (window.widget)		
		setTimeout ("widget.performTransition();", 0);	

	backside = true;
	
	document.getElementById("fliprollie").style.display = "none";
}

function editclick (event) {
	var eDiv = document.getElementById("edit-div");
	if (!editable) {
		eDiv.contentEditable = true;
		editable = true;
	}
}

function doneMouseUp(event) {
	var front = document.getElementById("front");
	var back = document.getElementById("behind");
	var eDiv = document.getElementById("edit-div");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display="block";	
	back.style.display="none";
	
	updateLayout();
	
	if (window.widget)
		setTimeout ("widget.performTransition();", 0);
	backside = false;
}

function fontChanged() {
	var fontPopUp = document.getElementById("fontStyle-comboBox");
	var font = fontPopUp.options[fontPopUp.selectedIndex].value;

	document.getElementById("fontStyle-title").innerHTML = fontPopUp.options[fontPopUp.selectedIndex].innerHTML;
	document.getElementById("edit-div").style.fontFamily = font;
	gCurrentFont = font;
	
	//Update Font Info
	var fontInfo = TypeCastFontManager.getLocalizedFontInfo(font);
	var fontFullName = fontInfo[0];
	var fontFormat = fontInfo[1];
	var fontFamName = fontInfo[2];
	var fontEncodName = fontInfo[3];
	gFontContainer = fontInfo[4];
	var containerName = fontInfo[5];
	gFontFile = fontInfo[6];
	var fileName = fontInfo[7];
	var copyName = fontInfo[8];
	var s;
	
	s = "<font style='font-weight:bold; font-size:13px'>" + fontFullName + "</font><br><font style='font-weight:normal; color:#666; font-size:11px'>" + localizedFormatLabel(fontFormat) + "</font>";
	document.getElementById("iFontName").innerHTML = s;
	document.getElementById("tFontName").innerHTML = fontFullName;
	
	s = "<font style='font-weight:bold; color:#666; font-size:13px'>" + localizedFamilyLabel(fontFamName) + "</font><br><font style='font-weight:normal; color:#666; font-size:11px'>" + localizedEncodingLabel(fontEncodName) + "</font>";
	document.getElementById("iFontFamily").innerHTML = s;
	document.getElementById("iFontPreview").style.fontFamily = font;
	
	s = "";
	s = s + "<span id='iFontContainerButton' onclick='revealFontContainer();'><img src='Images/RevealIcon.png' align='absmiddle'> &nbsp;<font style='font-weight:bold; color:#666; font-size:11px; vertical-align:middle'>" + getLocalizedString("Show Font File") + "</font></span>";
	if (gFontFile != null && gFontFile != "") s = s + "&nbsp; &nbsp; &nbsp; &nbsp; <span id='iFontContainerButton' onclick='revealFontFile();'><img src='Images/RevealIcon.png' align='absmiddle'> &nbsp;<font style='font-weight:bold; color:#666; font-size:11px; vertical-align:middle'>" + getLocalizedString("Show PS File") + "</font></span>";
	document.getElementById("iFontReveal").innerHTML = s;
	
	if (window.widget) {
		widget.setPreferenceForKey(font, createKey("font"));
	}
	
	syncTitles();
	updateLayout();
}

var flipShown = false;

var animation = {duration:0, starttime:0, to:0.5, now:0.0, from:0.0, element:null, timer:null};

function limit_3 (a, b, c) {
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
    return from + (to - from) * ease;
}

function animate() {
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.element.style.opacity = animation.now;
}


function mousemove (event) {
	if (!flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.element = document.getElementById ("flip");
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.5;
		animate();
		flipShown = true;
	}
	
	if (!editable)
	{
		document.getElementById("edit-div").contentEditable = true;
		editable = true;
	}
}

function mouseexit (event) {
	if (flipShown)
	{
		// fade out the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.element = document.getElementById ("flip");
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function onclickOverride (event) {
	var element = event.target.parentNode;
	if (element.nodeName == "A") // its a link
	{
		
		if (window.widget)
			widget.openURL(element.innerHTML);
		
		event.stopPropagation();
		event.preventDefault();
		
		return true;
	}
}

var nodeInserted = false;
function mutationEvent (event) {
	if ((event.type == "DOMNodeRemoved") && (event.target.nodeName != "DIV")) {
		return;
	}
	
	if (event.type == "DOMNodeInserted")
		nodeInserted = true;
	
	if (timer != null)
		clearTimeout (timer);
	
	timer = setTimeout("writeWindow();", 5000);
	
	if (mtimer != null)
		clearTimeout(mtimer);
	
	mtimer = setTimeout("mutationTimer();", 0);

}

function mutationTimer() {
	var eDiv = document.getElementById("edit-div");
	
	if (nodeInserted) {
		updateElems(eDiv);
		nodeInserted = false;
	}

	updateLayout();
}

function loaded() {
	// only need to check for mutation events if we are in the dashboard
	if (window.widget) {
		setMode(gMode);

		var element = document.getElementById("edit-div");
		element.addEventListener ("DOMCharacterDataModified", mutationEvent, false);
		element.addEventListener ("DOMNodeInserted", mutationEvent, false);
		element.addEventListener ("DOMNodeRemoved", mutationEvent, false);
		
		var text = widget.preferenceForKey(createKey("text"));
		if (text != null)
			element.innerHTML = text;
		else
			element.innerHTML = getLocalizedString("Preview Text");

		var font = widget.preferenceForKey(createKey("font"));
		if (font != null)
			element.style.fontFamily = font;
		else
			element.style.fontFamily = TypeCastFontManager.getSystemFontName();

		var size = widget.preferenceForKey(createKey("size"));
		if (size != null)
			element.style.fontSize = size;
		else
			element.style.fontSize = "36px";
		
		gCurrentFont = element.style.fontFamily ? element.style.fontFamily : "LucidaGrande";
		gCurrentFontSize = element.style.fontSize ? element.style.fontSize : "36px";

		var prevFont = gCurrentFont;	
		populateFontFamilies();
		populatePointSizes();

		var sysFont = TypeCastFontManager.getSystemFontName();
		if (setFont(prevFont) || setFont(sysFont)) { }
		
		document.getElementById("iFontPreview").innerHTML = "<hr noshade size='1' color='0.8, 0.8, 0.8'>" + getLocalizedString("PreviewString");

		setMaxSize(element.style.fontSize);
		gCurrentFont = element.style.fontFamily;

		setSize(null);
	}
	
}

function keydown (event) {
	var eDiv = document.getElementById("edit-div");
	var upElem, upIdx;
	var downElem, downIdx;
	
	//Family/Style Up
	//document.getElementById("edit-div").innerHTML = event.charCode; //Testing
	if (event.charCode == 63232 && event.metaKey) {
		
		if (event.altKey) upElem = document.getElementById("fontStyle-comboBox");
		else upElem = document.getElementById("fontFamily-comboBox");
		
		upIdx = upElem.selectedIndex - 1;
		if (upIdx < 0) { upIdx = 0; TypeCastFontManager.beep(); }
		if (upIdx >= upElem.length) { upIdx = upElem.length - 1; TypeCastFontManager.beep(); }
		upElem.selectedIndex = upIdx;
		upElem.onchange();
		
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	
	//Family/Style Down
	if (event.charCode == 63233 && event.metaKey) {
		
		if (event.altKey) downElem = document.getElementById("fontStyle-comboBox");
		else downElem = document.getElementById("fontFamily-comboBox");

		downIdx = downElem.selectedIndex + 1;
		if (downIdx < 0) { downIdx = 0; TypeCastFontManager.beep(); }
		if (downIdx >= downElem.length) { downIdx = downElem.length - 1; TypeCastFontManager.beep(); }
		downElem.selectedIndex = downIdx;
		downElem.onchange();
		
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	
	if (event.metaKey && String.fromCharCode(event.charCode) == "i") {
		setMode(kModeInfo);
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	
	if (event.metaKey && String.fromCharCode(event.charCode) == "t") {
		setMode(kModeText);
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
		
	if (event.metaKey && String.fromCharCode(event.charCode) == "a") {
		selectall();
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	
	//Size Up
	if (event.charCode == 44 && event.metaKey && event.shiftKey) {
		upElem = document.getElementById("pointSize-comboBox");
		upIdx = upElem.selectedIndex - 1;
		if (upIdx < 0) { upIdx = 0; TypeCastFontManager.beep(); }
		if (upIdx >= upElem.length) { upIdx = upElem.length - 1; TypeCastFontManager.beep(); }
		upElem.selectedIndex = upIdx;
		upElem.onchange();
		
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	
	//Size Down
	if (event.charCode == 46 && event.metaKey && event.shiftKey) {
		downElem = document.getElementById("pointSize-comboBox");
		downIdx = downElem.selectedIndex + 1;
		
		if (downIdx < 0) { downIdx = 0; TypeCastFontManager.beep(); }
		if (downIdx >= downElem.length) { downIdx = downElem.length - 1; TypeCastFontManager.beep(); }
		downElem.selectedIndex = downIdx;
		downElem.onchange();
		
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	
	if (event.charCode == 8 /* delete */) {
		if ( (eDiv.innerText.length == 0) ||
			 ((eDiv.innerText.length == 1) && (eDiv.innerText.charCodeAt(0) == 10)) ) {
			event.stopPropagation();
			event.preventDefault();
			return false;
		}
	}
	
	//Only allow returns if we have room for them
	if (((event.charCode == 3) || (event.charCode == 13)) &&
		 !allowReturns()) {
		event.stopPropagation();
		event.preventDefault();
		return false;
	}

	if (savedHTML == eDiv.innerHTML)
		return false;
	else
		savedHTML = eDiv.innerHTML;
}

function allowReturns() {
	var eDiv = document.getElementById("edit-div");
	
	gTextHeight = eDiv.offsetHeight;
	return ((gTextHeight + parseInt(eDiv.style.fontSize)) < editHeight);
}

document.addEventListener("keydown", keydown, true);

function enterflip(event) {
	document.getElementById("fliprollie").style.display = "block";
}

function exitflip(event) {
	document.getElementById("fliprollie").style.display = "none";
}

function setMaxSize(fontSize) {
	var fs = parseInt(fontSize);
	
	if (fs < 18)
		fs += 1;
	else
		fs += 2;
	gMaxSize = fs * parseInt(editHeight/fs);
	document.getElementById("edit-div").style.clip = "rect(auto auto " + gMaxSize + "px auto)";
}

function updateElems(element) {
	element.style.fontSize = gCurrentFontSize;
	element.style.fontFamily = gCurrentFont;

	var elemsInDiv = element.getElementsByTagName("span");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].style.fontSize = "";
		elemsInDiv[i].style.fontFamily = "";
	}
	elemsInDiv = element.getElementsByTagName("div");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].style.fontSize = "";
		elemsInDiv[i].style.fontFamily = "";
	}
	elemsInDiv = element.getElementsByTagName("p");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].style.fontSize = "";
		elemsInDiv[i].style.fontFamily = "";
	}
	elemsInDiv = element.getElementsByTagName("font");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].size = null;
		elemsInDiv[i].face = null;
	}
}

function syncTitles() {
	
	var elem;
	elem = document.getElementById("fontFamily-comboBox");
	document.getElementById("fontFamily-title").innerHTML = elem.options[elem.selectedIndex].innerHTML;

	elem = document.getElementById("fontStyle-comboBox");
	document.getElementById("fontStyle-title").innerHTML = elem.options[elem.selectedIndex].innerHTML;

	elem = document.getElementById("pointSize-comboBox");
	document.getElementById("pointSize-title").innerHTML = elem.options[elem.selectedIndex].innerHTML;
	
}

function setFamily(elem) {
	if (window.widget) {
		var newFam = elem.options[elem.selectedIndex].value;
		var convFont = TypeCastFontManager.convertFontToFamily(gCurrentFont, newFam);
		populateFontStyles();
		if (setFont(convFont)) { }
	}
}

function setStyle(elem) {
	if (window.widget) {
		var newFont = elem.options[elem.selectedIndex].value;
		if (setFont(newFont)) {}
	}
}

function setFont(fnt) {
	var famIdx = -1;
	
	if (window.widget) {
		//Get family
		var fntFam = TypeCastFontManager.getFamilyName(fnt);
		if (fntFam == null || fntFam == "") {
			return false;
		}
		
		//Find family in family popup
		var famPop = document.getElementById("fontFamily-comboBox");
		if (famPop.options[famPop.selectedIndex].value == fntFam) {
			famIdx = famPop.selectedIndex;
		
		} else {
			for (var i = 0; i < famPop.length; i++) {
				if (famPop.options[i].value == fntFam) {
					famPop.selectedIndex = i;
					famIdx = i;
					populateFontStyles();
					break;
				}
			}
		}
		
		if (famIdx == -1) {
			return False;
		}
		
		//Select font style
		var styPop = document.getElementById("fontStyle-comboBox");
		for (var j = 0; j < styPop.length; j++) {
			if (styPop.options[j].value == fnt) {
				styPop.selectedIndex = j;
				fontChanged();
				return true;
			}
		}
	}
	
	return false;
}

function setSize(elem) {

	if (elem == document.getElementById("pointSize-comboBox") && elem.selectedIndex >= 0) {
		document.getElementById("edit-div").style.fontSize = elem.options[elem.selectedIndex].value;
		
	} else {
		var sizePop = document.getElementById("pointSize-comboBox");
		var currSize = document.getElementById("edit-div").style.fontSize;

		sizePop.selectedIndex = -1;
		for (var i = 0; i < sizePop.length; i++) {
			if (currSize == sizePop.options[i].value) {
				sizePop.selectedIndex = i;
				break;
			}
		}
	}
	
	var size = document.getElementById("edit-div").style.fontSize;
	
	if (window.widget) {
		widget.setPreferenceForKey(size, createKey("size"));
	}
	
	var sizePop = document.getElementById("pointSize-comboBox");
	if (sizePop.selectedIndex >= 0) {
		document.getElementById("pointSize-title").innerHTML = sizePop.options[sizePop.selectedIndex].innerHTML;
	} else {
		document.getElementById("pointSize-title").innerHTML = "";
	}
	
	syncTitles();
	updateLayout();
	
	gCurrentFontSize = size;

}

function setMode(iMode) {
	if (iMode == kModeText) {
		gMode = kModeText;
		document.getElementById("mode-t-button").style.opacity = 0.6;
		document.getElementById("mode-t-div").style.display = "block";
		document.getElementById("tFontName").style.display = "block";
		
	} else {
		document.getElementById("mode-t-button").style.opacity = 0.3;
		document.getElementById("mode-t-div").style.display = "none";
		document.getElementById("tFontName").style.display = "none";
	}

	if (iMode == kModeInfo) {
		gMode = kModeInfo;
		document.getElementById("mode-i-button").style.opacity = 0.6;
		document.getElementById("mode-i-div").style.display = "block";
		document.getElementById("iFontName").style.display = "block";
		document.getElementById("iFontFamily").style.display = "block";
		document.getElementById("iFontPreview").style.display = "block";
		document.getElementById("iFontReveal").style.display = "block";
	} else {
		document.getElementById("mode-i-button").style.opacity = 0.3;
		document.getElementById("mode-i-div").style.display = "none";
		document.getElementById("iFontName").style.display = "none";
		document.getElementById("iFontFamily").style.display = "none";
		document.getElementById("iFontPreview").style.display = "none";
		document.getElementById("iFontReveal").style.display = "none";
	}

		updateLayout();
}

function populateFontFamilies() {
	try {
		var famPopup = document.getElementById("fontFamily-comboBox");
		var famNames = TypeCastFontManager.availableFontFamilies();

		while (famPopup.length > 0)
			famPopup.remove(0); //Remove all rows
		
		for (var i = 0; i < famNames.length; i++) {
			var famName = famNames[i];
			var optionElement = document.createElement("option");
			optionElement.setAttribute("value", famName);
			optionElement.innerHTML = famName;
			famPopup.appendChild(optionElement);
		}
	} catch(ex) {}
}

function populateFontStyles() {
	try {
		var famPopUp = document.getElementById("fontFamily-comboBox");
		var famName = famPopUp.options[famPopUp.selectedIndex].value

		var styPopUp = document.getElementById("fontStyle-comboBox");
		var styNames = TypeCastFontManager.availableMembersOfFontFamily(famName);

		while (styPopUp.length > 0)
			styPopUp.remove(0); //Remove all rows
		
		for (var i = 0; i < styNames.length; i++) {
			var styName = styNames[i];
			var optionElement = document.createElement("option");
			optionElement.setAttribute("value", styName[0]);
			optionElement.innerHTML = styName[1];
			styPopUp.appendChild(optionElement);
		}

		var title = document.getElementById("fontStyle-title");
		var popArr = document.getElementById("fontStyle-arrows")
		if (styPopUp.length <= 1) {
			title.style.opacity = 0.5;
			popArr.style.opacity = 0.4;
		} else {
			title.style.opacity = 1.0;
			popArr.style.opacity = 0.8;
		}
	} catch(ex) {}
}

function populatePointSizes() {
	try {
		var sizPopup = document.getElementById("pointSize-comboBox");
		var fontSizes = new Array(6, 7, 8, 9, 10, 11, 12, 14, 18, 21, 24, 36, 48, 60, 72);
		
		while (sizPopup.length > 0)
			sizPopup.remove(0); //Remove all rows
		
		for (var i = 0; i < fontSizes.length; i++) {
			var fontSize = fontSizes[i];
			var optionElement = document.createElement("option");
			optionElement.setAttribute("value", fontSizes[i] + "px");
			optionElement.innerHTML = fontSizes[i] + " pt";
			sizPopup.appendChild(optionElement);
		}
	} catch(ex) {}
}

function updateLayout() {

	setMaxSize(gCurrentFontSize);

	var eDiv = document.getElementById("edit-div");
	var oldTop = eDiv.offsetTop;
	var newTop = Math.round(editHeight/2) - Math.round(eDiv.offsetHeight/2);
	if (newTop < 0) newTop = 0;
	if (newTop > editHeight/2) newTop = editHeight/2;
	newTop += editTop;
	if (oldTop != newTop) { eDiv.style.top = "" + newTop + "px"; eDiv.style.height = ""; }
}

function revealFontContainer() {
	if (window.widget) {
		if (gFontContainer != null && gFontContainer != "" && TypeCastFontManager.revealPathInFinder(gFontContainer)) {
			widget.openURL("");
		} else {
			TypeCastFontManager.beep();
		}
	}
}

function revealFontFile() {
	if (window.widget) {
		if (gFontFile != null && gFontFile != "" && TypeCastFontManager.revealPathInFinder(gFontFile)) {
			widget.openURL("");
		} else {
			TypeCastFontManager.beep();
		}
	}
}

function visitCodeLine() {
	if (window.widget) {
		window.widget.openURL("http://www.code-line.com/software");
	}
}

function visitTypeCast() {
	if (window.widget) {
		window.widget.openURL("http://www.code-line.com/typecast");
	}
}

function dumpAttrs(attrs) {
	for (var i = 0 ; i < attrs.length; i++) {
		if (widget) alert("attr " + i + " " + attrs[i].name + " " +  attrs[i].value);
	}
}
